

# In[1]:


import os
import cv2
import numpy as np
from imgaug import augmenters as iaa
from sklearn.model_selection import train_test_split


# In[2]:


def random_augmentation(image):
    seq = iaa.Sequential([
        iaa.Affine(rotate=(-10, 10)),
        iaa.Multiply((0.7, 1.3)),
    ])

    augmented_image = seq(image=image)
    kernel_size = (5, 5)
    blurred_image = cv2.GaussianBlur(augmented_image, kernel_size, 0)

    return blurred_image


# In[ ]:


def apply_augmentation_to_folder(input_folder, output_folder):
    image_files = [f for f in os.listdir(input_folder) if f.endswith(('.jpg', '.jpeg', '.png'))]

    if len(image_files) < 3:
        print("Not enough images for augmentation.")
        return

    part1, remaining_files = train_test_split(image_files, test_size=0.5, random_state=42)
    part2, part3 = train_test_split(remaining_files, test_size=0.5, random_state=42)
    parts = [part1, part2, part3]

    os.makedirs(output_folder, exist_ok=True)

    for part in parts:
        for image_file in part:
            image_path = os.path.join(input_folder, image_file)
            image = cv2.imread(image_path)

            augmented_image = random_augmentation(image)

            augmented_image_path = os.path.join(output_folder, f"augmented_{image_file}")
            cv2.imwrite(augmented_image_path, augmented_image)

if __name__ == "__main__":
    input_folder = r"C:\Users\Plaksha\Desktop\trail"
    output_folder = os.path.join(input_folder, "aug_done")
    apply_augmentation_to_folder(input_folder, output_folder)

